<?php //custom css - $stylesheet = array('admin/plugins/albuns/css/gridGallery.css'); ?>
<?php include PATH_VIEW.'/layout/header.tpl'; ?>

<div id="ajaxArea">
	<div class="container bg-body-tertiary p-3">
	
		<div class="row">
			<div class="col-md-8 mb-4">
				<section id="column1" class="timetable">

					<h1 class="title-page"><?php echo $header_title; ?></h1>
					<section id="breadcrumb" class="border-bottom mb-4">
						<?php include PATH_VIEW.'/layout/breadcrumb.tpl' ?>
					</section>

					<div class="card mb-3 p-2">
						<ul class="nav nav-pills nav-fill"  role="tablist">
							<?php foreach($nav_tabs as $key){ ?>
								<li class="nav-item" role="presentation">
									<button class="nav-link <?php echo ($key == $current_week)?'active':''; ?>" id="nav-<?php echo $key; ?>-tab" data-bs-toggle="tab" data-bs-target="#nav-<?php echo $key; ?>" type="button" role="tab" aria-controls="nav-<?php echo $key; ?>" aria-selected="true"><?php echo $_LANG[$key]; ?></button>
								</li>
							<?php } ?>
						</ul>
					</div>

					<div class="tab-content">
						<?php if($dataList){ ?>
							<?php foreach($dataList as $key => $value){ ?>
								<div class="tab-pane fade <?php echo ($key == $current_week)?'show active':''; ?>" id="nav-<?php echo $key; ?>" role="tabpanel" aria-labelledby="nav-<?php echo $key; ?>-tab" tabindex="0">
									<?php if($value){ ?>
										<div class="card">
										<table class="table table-striped align-middle text-center">
											<thead >
												<tr class="text-uppercase">
													<th scope="col"><?php echo $_LANG['time']; ?></th>
													<th scope="col"><?php echo $_LANG['program']; ?></th>
													<th scope="col"><?php echo $_LANG['presenter']; ?></th>
												</tr>
											</thead>
											<tbody>
												
											<?php foreach($value as $value){ ?>
												<?php 
													$programActive = null;
													if ($timeCurrent >= $value->time_start && 
														$timeCurrent <= $value->time_end && 
														$current_week == $key) { 
														$programActive = 'active';
													} 
												?>
												<tr class="<?php echo $programActive; ?>">
													<th scope="row">
													<?php echo ($programActive)?'<span class="just-now">'.$_LANG['just_now'].'</span>':''; ?>
														<?php echo $value->time_start; ?> - <?php echo $value->time_end; ?></th>
													<td>
														
														<?php echo $value->program_name; ?>
													</td>
													<td>
														<img class="avatar rounded mb-1" loading="lazy" src="<?php echo PATH_SYSTEM."public/avatar/".$value->avatar; ?>" alt="<?php echo $value->full_name; ?>">
														<span class="d-block"><?php echo $value->full_name; ?></span>
													</td>
												</tr>
											<?php } ?>
											</tbody>
										</table>
										</div>
									<?php }else{ ?>
										<div class="alert alert-danger" role="alert">
											<?php echo $_LANG['empty'] ?>
										</div>
									<?php } ?>
										
								</div>
							<?php } ?>
						<?php } ?>
					</div>
				</section>
			</div>

			<div class="col-md-4">
				<aside>
					<section id="column2" class="row">
						<?php 
							$widgetPos = 4;
							include PATH_VIEW.'/layout/widget.tpl';
						?>
					</section>
				</aside>
			</div>


		</div>
		
	</div>
</div>

<?php include PATH_VIEW.'/layout/footer.tpl'; ?>